#version 140
#extension GL_EXT_gpu_shader4 : enable
//Jiggly plasmaMod01.fsh  by  jarble
//https://www.shadertoy.com/view/NtByzG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.177  //*0.314159  //
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 rotate(vec2 v, float a) {
	float s = sin(a);
	float c = cos(a);
	return mat2(c, -s, s, c)*v;
}

vec2 triangle_wave(vec2 a,float num,int iters){
    a = rotate(a,num*radians(180.));
    vec2 to_return = abs(fract((a+vec2(1.,0.5))*1.5)-.5);
    return to_return;
    //return to_return/(1.5+(iters > 0?1.:0.)*(a.x+a.y)/4.);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    gl_FragColor = vec4(0.0);
    vec3 col = vec3(0.);
    float t1 = 1.;
    vec2 uv = (gl_FragCoord.xy)/iResolution.y/t1/2.0;
    float time1 = iTime/64.;
    uv += vec2(time1/2.0,time1/3.0)/t1/4.0+(vec2(cos(time1),sin(time1)))*8./t1;
    float scale = 1.5;
    float p1 = 1.;
    vec2 t2 = vec2(0.);
    vec2 t3 = vec2(0.);
    vec2 t4 = vec2(0.);
    float rotation_number = 0.;
    for(int k = 0; k < 12; k++){
        rotation_number = float(1+k)*1.5;
        //rotation_number += float(int(uv.x+uv.y)+1+k)*.5;

        uv += t2.yx;
        t2 = -p1*triangle_wave(uv-.5,rotation_number,k);
        t3 = p1*triangle_wave(uv.yx,rotation_number,k);
        t4 = t2-p1*triangle_wave(uv-.5-iTime,rotation_number,k)/8.;
        uv = t4.y*t2-t4.x*t3;
        p1 *= -1.;
        float multiplier = 1.5;
        col.x = max(uv.y+uv.x-col.x,col.x)/multiplier;
        //col.x = max(((uv.y+uv.x)-col.x)/multiplier,col.x*multiplier);
        //col.x = max(uv.y*(1.25)+uv.x/(1.25)-col.x,col.x);
        //col.x = max(uv.y+uv.x-col.x,col.x*multiplier)/multiplier;

        col = abs(col.yzx-vec3(1.-col.x))/multiplier;
        uv /= scale;
    }
    gl_FragColor = vec4(col*2.,1.0);
}
